
function OnAfterSceneLoaded(self)
  CreateTriggerTargets(self)
  CreateTriggerSources(self)
end

function OnThink(self)
  if not self.initialized then
    self.initialized = true
    self.qDoneIron = false
    self.qDoneStone = false
    self.p0 = Citadels.GetPlayer(0)
    
    if not self.loaded then
      self.qDoneLake = 0
    end
    
    self.rIron:LinkToTarget("riActive")
    self.rStone:LinkToTarget("rsActive")
  end
   
  if self.qDoneIron then
    self.p0:WinQuest('D05_IRON')
    self.p0:AddResource(3,100)
    self.rIron:TriggerAllTargets()
    self.qDoneIron = false
  end
  
  if self.qDoneStone then
    self.p0:WinQuest('D05_STONE')
    self.p0:AddResource(2,80)
    self.rStone:TriggerAllTargets()
    self.qDoneStone = false
  end
  
  if self.qDoneLake == 2 then
    self.p0:WinQuest('D05_FARMS')
    self.p0:AddResource(0,120)
    self.p0:AddResource(6,40)
    self.qDoneLake = 0
  end
  
end

function OnTrigger(self, source, target)
  if target == "questIron" then
    self.qDoneIron = true
  elseif target == "questStone" then
    self.qDoneStone = true
  elseif target == "questLake" then
    self.qDoneLake = self.qDoneLake + 1
    Debug:Log("self.qDoneLake = " .. self.qDoneLake)
  end
end

function OnSerialize(self, ar)
  if (ar:IsLoading()) and Citadels.GetLoadGameRunning() then
    CreateTriggerSources(self)
    self.loaded = true
    self.qDoneLake = tonumber(ar:Read())
    Debug:Log("self.qDoneLake = " .. self.qDoneLake)
  elseif (ar:IsSaving()) then
    ar:Write(tostring(self.qDoneLake))
  end
end

function CreateTriggerTargets(self)
  self:AddTriggerTarget("questIron")
  self:AddTriggerTarget("questStone")
  self:AddTriggerTarget("questLake")
end

function CreateTriggerSources(self)
  self:AddTriggerSource("rIron")
  self:AddTriggerSource("rStone")
end
